<?php
if(isset($_POST['submit']) ) {
// form was submitted -- this is a POST back
	require_once('/var/www/html/vendor/autoload.php');

	/*
	See Mailchimp PHP wrapper library info for library loaded above:
	https://github.com/mailchimp/mailchimp-transactional-php
	See docs for underlying Mailchimp Transactional ApiClient
	https://mailchimp.com/developer/transactional/guides/quick-start/
	*/

	// global vars
	$mailchimp=NULL; //Mailchimp (MC)or Mandrill transact API object
	$message=NULL;  //MC message object
	$display_data=NULL; // string of HTML table rows of form name-values
	$display_msg=NULL; // string with full HTML table and email message body
	$response=NULL; // MC tranact API response object
	$success=false; // Bool for success/failure of MC API send call and email status
	$status=""; // MC API response->status property
	$error_msg=""; // string for MCI API related error msgs

	date_default_timezone_set('UTC'); //for logging purposes

	function build_data_html($form_data) {
		// Iterates array, $form_data, building HTML rows <tr>s containing 'key: value' for member; 1 row per array member
		// Returns: string concatentation of all rpws
		$rows = "";
		foreach($form_data as $key =>$value){
		    $row = "<tr><td>";
		    $row .=  $key . ": " . $value;
		    $row .=  "</td></tr>\n";
		    $rows .= $row;
		}
		return $rows;
	}

	// create MC API wrapper obj and set API key to authorize access
	$mailchimp = new MailchimpTransactional\ApiClient();
	$mailchimp->setApiKey('_mMy6SCbNIvr5J-xxeVvvg');

	// set up MC message object with email fields
	$message = array(
	    'subject' => 'Hello from the Gorge of Enternal Peril',
	    'from_email' => 'mailbox@blueteamdev.com',
	    'from_name' => 'Mailbox Blueteam',
	    'html' => '<p>this friendly message sent via Mandrill/Mailchimp transactional API</p><table>##0##</table>',
	    'to' => array(array('email' => 'catcher@blueteamdev.com', 'name' => 'Chris Blueteam'))
		);

	// create basic HTML table displaying form data
	$display_data = build_data_html($_POST);
	$display_msg = str_replace('##0##', $display_data, $message['html']);

	// fill out HTML table in message body
	$message['html'] = $display_msg;

	// fire off MC transactional email
	try {
	   $response = $mailchimp->messages->send(["message" => $message]);
	   $success=true;
	}
	 /*
	catch (GuzzleHttp\Exception\ServerException $ex) {
	    $guzzleresponse = $ex->getResponse();
	    $guzzleresponseBodyAsString = $guzzleresponse->getBody()->getContents();
	    $success=false;
	    $error_msg = 'API call failed: ' . $guzzlresponseBodyAsString;
	}
	 */
	catch (Error $e) {
	    $success = false;
	    $error_msg = 'API call failed: ' . $e->getMessage();
	}

	// handle and parse MC API response
	if ($success && $response && is_array($response)) {
		// API call returned something and it was an array, as expected
		$status = $response[0]->status;
		$rejected_reason = $response[0]->reject_reason;

		if ($status == 'sent' && $rejected_reason == '') {
		   $success = true;
		}
	} elseif ($success && $response && is_object($response)) {
		// API call returned something and it was an unexpected is_object
		// NOTE: responses for invalid API keys don't trigger an exception that can be caught,
		//       and instead return an invalid JSON string...the raw guts of a GuzzleHttp\Exception\ServerException
		$success = false;
		if (strpos($response, 'Invalid_Key') !== false) {
		  $error_msg = 'Invalid Mailchimp Transactional API Key.';
		} else {
			$error_msg = 'API returned unexpected response or format.';
		}
	}

	// log the error (the API call triggered an exception or a response was returned but with unexpected values)
	if (! $success)  error_log(DATE(DATE_ATOM) . ' -- REQUEST ACCOUNT MANAGER ERROR. ' . $error_msg);
	// attempt to mail the error to a local system user, imap_mailboxmsginfo
	//error_log($error_msg, 1, "mccannmtl@gmail.com");

}
// END POST back
?>
<!doctype html>
<html lang=en>
  <head>
  <meta charset=utf-8>
  <title></title>
  <style>
     label{display:block}
     input{display:block;margin-bottom:20px;}
  </style>
  </head>
  <body>
    <h1>Welcome to the Gorge of Eternal Peril</h1>
    <p>This form posts back to PHP form handler on same URL/page, which:</p>
    <ul>
			<li>Instantiates a MailChimp Transactional Client for API comms and a MailChimp email message object</li>
			<li>Grabs the form data array</li>
			<li>Iterates that array, appending a row or line with each field label:value to the message body</li>
			<li>Fires the email via MailChimp/Mandrill Transactional API</li>
			<li>Handles API success/error response, displaying simple success/failure msg</li>
   </ul>

<?php if(isset($_POST['submit']) && $success): ?>
<h1>Success! Email sent.</h1>
<?php elseif(isset($_POST['submit'])): ?>
<h1>Oops! There was an error sending the email. Please try again.</h1>
<?php else: ?>
    <form action="" method="post">
    	<label for="txtName">What is your name?</label>
    	<input id="txtName" name="txtName" type="text" maxLength="128">

    	<label for="txtQuest">What is your quest?</label>
    	<input id="txtQuest" name="txtQuest" type="text" maxLength="128">

    	<label for="colorFav">What is your favorite color?"</label>
    	<input type="color" id="favcolor" name="favcolor" value="#0000FF">

    	<input id="submit" name="submit" type="submit" value="Submit answers">
    </form>
<?php endif; ?>

  </body>
</html>
