<?php
if(isset($_POST['submit']) ) {
// form was submitted -- this is a POST back
	require_once('/var/www/html/vendor/autoload.php');

	/*
	See Mailchimp PHP wrapper library info for library loaded above:
	https://github.com/mailchimp/mailchimp-marketing-php
	See docs for underlying Mailchimp Marketing API:
  https://mailchimp.com/developer/marketing/guides/quick-start/
	API Reference doc:
	https://mailchimp.com/developer/marketing/api/
	*/

	// global vars
	$api_key = '2af9a41a9dbaea59d8046bfe21680b5c-us5'; //valid MC Marketing API key
	$server_prefix = 'us5'; //valid MC server prefix
	$list_id = '204d777b35'; //unique MC audience/list ID
	$mailchimp=NULL; //Mailchimp (MC) or Mandrill transact API object
	$response=NULL; // MC tranact API response object
	$error_msg=""; // string for MCI API related error msgs

	date_default_timezone_set('UTC'); //for logging purposes

	// create MC API wrapper obj and set API key and MC regional server to authorize access
	$mailchimp = new \MailchimpMarketing\ApiClient();
	$mailchimp->setConfig([
	  'apiKey' => '2af9a41a9dbaea59d8046bfe21680b5c-us5',
	  'server' => 'us5'
	]);

	try {
	  // add audience member (contact) to specified audience/list
	    $response = $mailchimp->lists->addListMember($list_id, [
	        "email_address" => $_POST["txtEmailAddress"],
	        "status" => "subscribed",
	        "merge_fields" => [
	          "FNAME" => $_POST["txtFirstName"],
	          "LNAME" => $_POST["txtLastName"],
	          "TITLE" => $_POST["txtTitle"],
						"TYPE" => $_POST["selRelationship"],
						"RX" => $_POST["radPrecription"]
	        ]
	    ]);
	    //print_r($response);
	} catch (MailchimpMarketing\ApiException $mce) {
	    // handle MC exception -- have yet to see this fire...may be an issue with GuzzleHttp library used in MC PHP wrapper
	    echo 'Caught Mailchimp APIException: ', $mce->getMessage();
	} catch (Exception $ex) {
	    // handle generic Exception
	    echo 'Caught exception: ',  $ex->getMessage();
	}

}
// END POST back
?>
<!doctype html>
<html lang=en>
  <head>
  <meta charset=utf-8>
  <title>Stay in the Know</title>
  <style>
     label{display:block}
     input, select{display:block;margin-bottom:20px;}
  </style>
  </head>
  <body>
    <h1>Sign Up for Spam Here!</h1>
    <p>This form posts back to PHP form handler on same URL/page, which:</p>
    <ul>
			<li>Instantiates a MailChimp Marketing API client for API comms</li>
			<li>Fires Mailchimp Marketing API call to add a contact to an audience (a member to a list)</li>
			<li>Handles API success/error response, displaying simple success/failure msg</li>
   </ul>

	 <?php if(isset($_POST['submit']) ): ?>
	 <h1>Success! You've been registered.</h1>
	 <?php elseif(isset($_POST['submit'])): ?>
	 <h1>Oops! There was an error sending the email. Please try again.</h1>
	 <?php else: ?>
	     <form action="" method="post">
	     	<label for="txtFirstName">First Name:</label>
	     	<input id="txtFirstName" name="txtFirstName" type="text" maxLength="128">

	     	<label for="txtLastName">Last Name:</label>
	     	<input id="txtLastName" name="txtLastName" type="text" maxLength="128">

				<label for="txtEmailAddress">Email:</label>
	     	<input id="txtEmailAddress" name="txtEmailAddress" type="text" maxLength="256">

	 			<label for="txtTitle">Title:</label>
	     	<input id="txtTitle" name="txtTitle" type="text" maxLength="32">

				<label for="selRelationship">Relationship (I am a...):</label>
				<select id="selRelationship" name="selRelationship">
				  <option value="patient">Patient</option>
				  <option value="caregiver">Caregiver</option>
				  <option value="other">Other</option>
				</select>

				Prescription?<br>
				<input type="radio" id="radPrecriptionYes" name="radPrecription" value="Yes" style="display:inline">
				<label for="radPrecriptionYes" style="display:inline">Yes</label><br>
				<input type="radio" id="radPrecriptionNo" name="radPrecription" value="No" style="display:inline">
				<label for="radPrecriptionNo" style="display:inline">No</label><br>

	     	<input id="submit" name="submit" type="submit" value="Submit">
	     </form>
	 <?php endif; ?>

  </body>
</html>
