<?php 
ini_set('display_errors', 1);
if(isset($_POST['email']) ) {
// form was submitted -- this is a POST back 

// global Google Recaptcha Vars
$recaptcha=NULL;  //Google recaptcha api response
$recaptcha_url="https://www.google.com/recaptcha/api/siteverify";  //Google URL to verify user response and provide score/feedback
$recaptcha_secret="6LcfHXgdAAAAAHaMuDS1YLsa4ziU2FBiI0TEDiyn";
$recaptcha_token=$_POST['g-recaptcha-response'] ?? '';  //Google recaptcha token ... expires every 2 min
/* Following var delcaration, $recaptcha_user_action, is for the desired recaptcha-protected action, as expressed on page/client
   NOTE: Google recaptcha only allows alpha and '_' chars for its 'action' *value* -- no dashes or numbers or symbols!
*/
$recaptcha_user_action=$_POST['hid-recaptcha-action'] ?? '';  //


	// global vars
	$mailchimp=NULL; //Mailchimp (MC)or Mandrill transact API object
	$message=NULL;  //MC message object
	$display_data=NULL; // string of HTML table rows of form name-values
	$display_msg=NULL; // string with full HTML table and email message body
	$response=NULL; // MC tranact API response object
	$success=false; // Bool for success/failure of MC API send call and email status
	$status=""; // MC API response->status property
	$error_msg=""; // string for MCI API related error msgs

	date_default_timezone_set('UTC'); //for logging purposes




	function build_data_html($form_data) {
		// Iterates array, $form_data, building HTML rows <tr>s containing 'key: value' for member; 1 row per array member
		// Returns: string concatentation of all rows
		$rows = "";
		foreach($form_data as $key =>$value){
		    $row = "<tr><td>";
		    $row .=  $key . ": " . $value;
		    $row .=  "</td></tr>\n";
		    $rows .= $row;
		}
		return $rows;
	}

	function build_privacy_request_html($form_data) {
		// Iterates array, $form_data, building HTML rows <tr>s containing 'key: value' for member; 1 row per array member
		// Returns: string concatentation of all rpws
		$row = "";
		$rows = "";
		unset($form_data['g-recaptcha-response']);  //remove recaptcha token, not needed for email we will send

		// phone-type will throw an error if not set
		$phoneType = '';
		if (isset($form_data['phone-type'])) $phoneType = $form_data['phone-type'];

		$row .= "<tr><td><strong>Request Type:</strong> " . $form_data['request-type'] . "</td></tr>";
		$row .= "<tr><td><strong>First Name:</strong> " . $form_data['firstName'] . "</td></tr>";
		$row .= "<tr><td><strong>Last Name:</strong> " . $form_data['lastName'] . "</td></tr>";
		$row .= "<tr><td><strong>Email:</strong> " . $form_data['email'] . "</td></tr>";
		$row .= "<tr><td><strong>Phone Number:</strong> " . $form_data['phone'] . "</td></tr>";
		$row .= "<tr><td><strong>Phone Type:</strong> " . $phoneType . "</td></tr>";
		$row .= "<tr><td><strong>Street Address Line 1:</strong> " . $form_data['street-address-1'] . "</td></tr>";
		$row .= "<tr><td><strong>Street Address Line 2:</strong> " . $form_data['street-address-2'] . "</td></tr>";
		$row .= "<tr><td><strong>State:</strong> " . $form_data['state'] . "</td></tr>";
		$row .= "<tr><td><strong>Zip:</strong> " . $form_data['zip'] . "</td></tr>";
		$rows .= $row;

		return $rows;
	}

	// check for a valid Recaptcha V3 token and check the Recaptcha V3 score
	$recaptcha = file_get_contents($recaptcha_url . '?secret=' . $recaptcha_secret . '&response=' . $recaptcha_token);
	$recaptcha = json_decode($recaptcha, true);

	if ($recaptcha['success']==true && $recaptcha['score']>=0.7 && $recaptcha['action']==$recaptcha_user_action) {
		//BEGIN RECAPTCHA OK/NOT-A-BOT
		require_once('../vendor/autoload.php');

		//Livmarli HCP - Request Account Manager
		//API Key:
		//Audience ID: d59b5affe8
		//Merge Fields
		//EMAIL
		//TITLE
		//FNAME
		//LNAME
		//PROFESSION
		//PHONE
		//ZIP

			/*
			See Mailchimp PHP wrapper library info for library loaded above:
			https://github.com/mailchimp/mailchimp-transactional-php
			See docs for underlying Mailchimp Transactional ApiClient
			https://mailchimp.com/developer/transactional/guides/quick-start/
			*/

	// create MC API wrapper obj and set API key to authorize access
	$mailchimp = new MailchimpTransactional\ApiClient();
	$mailchimp->setApiKey('jjnKm3DNJLXpXzqvRzPUEQ');

	// create basic HTML table displaying form data
	if (isset($_POST["form-name"]) && $_POST["form-name"] == "privacy-request-form") {
		// ***********************************
		// FOR THE 'PRIVACY REQUEST FORM' ONLY
		// ***********************************

		$emailTitlte = 'Livmarli Patient - Do Not Sell My Data Request';

		// set up MC message object with email fields
		$message = array(
			'subject' => $emailTitlte,
			'from_email' => 'commercial.ops@mirumpharma.com',
			'from_name' => 'LIVMARLI',
			'html' => '<p>'.$emailTitlte.'</p><table>'. build_privacy_request_html($_POST) .'</table>',
			'to' => array(array('email' => 'commercial.ops@mirumpharma.com', 'name' => 'Mirum Pharma'))
			// 'to' => array(array('email' => 'william.martin@mccannhealth.com', 'name' => 'William Martin'))
			// 'to' => array(array('email' => 'louis.mitchell@studiorx.com', 'name' => 'Louis Mitchell'))
		);
	} else {
		// **********************************************
		// FOR THE 'REQUEST AN ACCOUNT MANAGER' FORM ONLY
		// **********************************************

		$emailTitlte = 'LIVMARLI: Account Manager Request';

		// set up MC message object with email fields
		$message = array(
	    'subject' => $emailTitlte,
	    'from_email' => 'mailbox@blueteamdev.com',
	    'from_name' => 'Mailbox Blueteam',
	    'html' => '<p>'.$emailTitlte.'</p><table>'. build_data_html($_POST) .'</table>',
	    'to' => array(array('email' => 'catcher@blueteamdev.com', 'name' => 'Chris Blueteam'))
		);
	}

	// fire off MC transactional email
	try {
	   $response = $mailchimp->messages->send(["message" => $message]);
	   $success=true;

     echo json_encode($response);
	}
	 /*
	catch (GuzzleHttp\Exception\ServerException $ex) {
	    $guzzleresponse = $ex->getResponse();
	    $guzzleresponseBodyAsString = $guzzleresponse->getBody()->getContents();
	    $success=false;
	    $error_msg = 'API call failed: ' . $guzzlresponseBodyAsString;
	}
	 */
	catch (Error $e) {
	    $success = false;
	    $error_msg = 'API call failed: ' . $e->getMessage();
	}

	// handle and parse MC API response
	if ($success && $response && is_array($response)) {
		// API call returned something and it was an array, as expected
		$status = $response[0]->status;
		$rejected_reason = $response[0]->reject_reason;

		if ($status == 'sent' && $rejected_reason == '') {
		   $success = true;
		}
	} elseif ($success && $response && is_object($response)) {
		// API call returned something and it was an unexpected is_object
		// NOTE: responses for invalid API keys don't trigger an exception that can be caught,
		//       and instead return an invalid JSON string...the raw guts of a GuzzleHttp\Exception\ServerException
		$success = false;
		if (strpos($response, 'Invalid_Key') !== false) {
		  $error_msg = 'Invalid Mailchimp Transactional API Key.';
		} else {
			$error_msg = 'API returned unexpected response or format.';
		}
	}

	// log the error (the API call triggered an exception or a response was returned but with unexpected values)
	if (! $success)  error_log(DATE(DATE_ATOM) . ' -- REQUEST ACCOUNT MANAGER ERROR. ' . $error_msg);
	// attempt to mail the error to a local system user, imap_mailboxmsginfo
	//error_log($error_msg, 1, "mccannmtl@gmail.com");

	//END RECAPTCHA OK/NOT-A-BOT
	} else {
		//BEGIN RECAPTCHA FAIL/BOT
			$response = array("status"=>'failed', "reject_reason"=>'RECAPTCHA failed');
			echo $response;
			$x_forwarded = (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) ? $_SERVER['HTTP_X_FORWARDED_FOR'] : '';
			error_log(DATE(DATE_ATOM) . ' -- REQUEST ACCOUNT MANAGER ERROR. RECAPTCHA failed. RECAPTCHA score: ' . $recaptcha['score'] . '. RECAPTCHA action:' . $recaptcha['action'] . ' || REMOTE IP:' . $_SERVER['REMOTE_ADDR'] . ' || HTTP_X_FORWARDED_FOR:' . $x_forwarded	);
		//END RECAPTCHA FAIL/BOT
	}

}
// END POST back
?>
